# Generated by Django 5.1.3 on 2025-07-28 08:29

import django.db.models.deletion
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('users', '0005_failedloginattempt_loginactivity'),
    ]

    operations = [
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, max_length=50, null=True)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('phone', models.CharField(blank=True, max_length=20, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MarketVisit',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date', models.DateField(auto_now_add=True)),
                ('company_title', models.CharField(choices=[('plutontech', 'Plutotech'), ('oryxmedia', 'Oryxmedia')], max_length=40)),
            ],
        ),
        migrations.CreateModel(
            name='Typeofwork',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='InvoiceWork',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('type_of_work', models.CharField(blank=True, max_length=30, null=True)),
                ('invoice_no', models.CharField(blank=True, max_length=30, null=True)),
                ('invoice_amount', models.CharField(blank=True, max_length=50, null=True)),
                ('remarks', models.TextField()),
                ('customer_name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='employer_profile.customer')),
                ('market', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='invoiced_work', to='employer_profile.marketvisit')),
            ],
        ),
        migrations.CreateModel(
            name='Enquiries',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('type_of_work', models.CharField(blank=True, max_length=30, null=True)),
                ('descriptions', models.TextField()),
                ('customer_name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='employer_profile.customer')),
                ('market', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enquiries', to='employer_profile.marketvisit')),
            ],
        ),
        migrations.CreateModel(
            name='ConfirmedWork',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('type_of_work', models.CharField(blank=True, max_length=30, null=True)),
                ('so_no', models.CharField(blank=True, max_length=30, null=True)),
                ('so_amount', models.CharField(blank=True, max_length=50, null=True)),
                ('remarks', models.TextField()),
                ('customer_name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='employer_profile.customer')),
                ('market', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='confirmed_work', to='employer_profile.marketvisit')),
            ],
        ),
        migrations.CreateModel(
            name='PaymentCollected',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('invoice_no', models.CharField(blank=True, max_length=30, null=True)),
                ('rcvd_amount', models.CharField(blank=True, max_length=20, null=True)),
                ('remarks', models.TextField()),
                ('customer_name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='employer_profile.customer')),
                ('market', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='payments_collected', to='employer_profile.marketvisit')),
            ],
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, max_length=30, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('users', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.secureuser')),
            ],
        ),
        migrations.AddField(
            model_name='marketvisit',
            name='profiles',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reports', to='employer_profile.profile'),
        ),
        migrations.CreateModel(
            name='QuotesSubmitted',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('type_of_work', models.CharField(blank=True, max_length=30, null=True)),
                ('Quote_no', models.CharField(blank=True, max_length=30, null=True)),
                ('quote_amount', models.CharField(blank=True, max_length=50, null=True)),
                ('remarks', models.TextField()),
                ('customer_name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='employer_profile.customer')),
                ('market', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='quotes_submitted', to='employer_profile.marketvisit')),
            ],
        ),
    ]
