from rest_framework import serializers
from .models import (
    MarketVisit,
    Enquiries,
    QuotesSubmitted,
    ConfirmedWork,
    InvoiceWork,
    PaymentCollected,
    Profile, 
    Customer,
    Marketing
)

class CustomerSerializer(serializers.ModelSerializer):
    class Meta:
        model = Customer
        fields = [
            "id", "name", "start_date", "phone", "email"
        ]

class ProfileSerializer(serializers.ModelSerializer):
    class Meta:
        model = Profile
        fields = [
            "id", "users", "name"
        ]

class TotalEnquiriesSerializer(serializers.ModelSerializer):
    customer_name = serializers.CharField(required=False, allow_blank=True)
    type_of_work = serializers.CharField(required=False, allow_blank=True)
    descriptions = serializers.CharField(required=False, allow_blank=True)

    class Meta:
        model = Enquiries
        fields = ['id', 'customer_name', 'type_of_work', 'descriptions', 'created_at']

class TotalQuotesSubmittedSerializer(serializers.ModelSerializer):
    customer_name = serializers.CharField(required=False, allow_blank=True)
    type_of_work = serializers.CharField(required=False, allow_blank=True)
    Quote_no = serializers.CharField(required=False, allow_blank=True)
    quote_amount = serializers.CharField(required=False, allow_blank=True)
    remarks = serializers.CharField(required=False, allow_blank=True)

    class Meta:
        model = QuotesSubmitted
        fields = ['id', 'customer_name', 'type_of_work', 'Quote_no', 'quote_amount', 'remarks', 'created_at']

class TotalConfirmedWorkSerializer(serializers.ModelSerializer):
    customer_name = serializers.CharField(required=False, allow_blank=True)
    type_of_work = serializers.CharField(required=False, allow_blank=True)
    so_no = serializers.CharField(required=False, allow_blank=True)
    so_amount = serializers.CharField(required=False, allow_blank=True)
    remarks = serializers.CharField(required=False, allow_blank=True)

    class Meta:
        model = ConfirmedWork
        fields = ['id', 'customer_name', 'type_of_work', 'so_no', 'so_amount', 'remarks', 'created_at']

class TotalInvoiceWorkSerializer(serializers.ModelSerializer):
    customer_name = serializers.CharField(required=False, allow_blank=True)
    type_of_work = serializers.CharField(required=False, allow_blank=True)
    invoice_no = serializers.CharField(required=False, allow_blank=True)
    invoice_amount = serializers.CharField(required=False, allow_blank=True)
    remarks = serializers.CharField(required=False, allow_blank=True)

    class Meta:
        model = InvoiceWork
        fields = ['id', 'customer_name', 'type_of_work', 'invoice_no', 'invoice_amount', 'remarks', 'created_at']

class TotalPaymentCollectedSerializer(serializers.ModelSerializer):
    customer_name = serializers.CharField(required=False, allow_blank=True)
    invoice_no = serializers.CharField(required=False, allow_blank=True)
    rcvd_amount = serializers.CharField(required=False, allow_blank=True)
    remarks = serializers.CharField(required=False, allow_blank=True)

    class Meta:
        model = PaymentCollected
        fields = ['id', 'customer_name', 'invoice_no', 'rcvd_amount', 'remarks', 'created_at']

class MarketingSerializer(serializers.ModelSerializer):
    client_name = serializers.CharField(required=False, allow_blank=True)
    status = serializers.CharField(required=False, allow_blank=True)
    email = serializers.EmailField(required=False, allow_blank=True)
    contact_no = serializers.CharField(required=False, allow_blank=True)

    class Meta:
        model = Marketing
        fields = [
            'id',
            'client_name',
            'status',
            'email',
            'contact_no',
            'created_at'
        ]

class MarketVisitSerializer(serializers.ModelSerializer):
    enquiries = TotalEnquiriesSerializer(many=True, required=False)
    quotes_submitted = TotalQuotesSubmittedSerializer(many=True, required=False)
    confirmed_work = TotalConfirmedWorkSerializer(many=True, required=False)
    invoiced_work = TotalInvoiceWorkSerializer(many=True, required=False)
    payments_collected = TotalPaymentCollectedSerializer(many=True, required=False)
    total_marketing = MarketingSerializer(many=True, required=False)
    profiles_name = serializers.CharField(source='profiles.name', read_only=True)

    class Meta:
        model = MarketVisit
        fields = [
            'id',
            'profiles',
            'profiles_name',
            'date',
            'company_title',
            'enquiries',
            'quotes_submitted',
            'confirmed_work',
            'invoiced_work',
            'payments_collected',
            'total_marketing'
        ]

    def create(self, validated_data):
        enquiries_data = validated_data.pop('enquiries', [])
        quotes_submitted_data = validated_data.pop('quotes_submitted', [])
        confirmed_work_data = validated_data.pop('confirmed_work', [])
        invoiced_work_data = validated_data.pop('invoiced_work', [])
        payments_collected_data = validated_data.pop('payments_collected', [])
        total_marketing_data = validated_data.pop('total_marketing', [])

        market_visit = MarketVisit.objects.create(**validated_data)

        for enquiry_data in enquiries_data:
            Enquiries.objects.create(market=market_visit, **enquiry_data)

        for quote_data in quotes_submitted_data:
            QuotesSubmitted.objects.create(market=market_visit, **quote_data)

        for work_data in confirmed_work_data:
            ConfirmedWork.objects.create(market=market_visit, **work_data)

        for invoice_data in invoiced_work_data:
            InvoiceWork.objects.create(market=market_visit, **invoice_data)

        for payment_data in payments_collected_data:
            PaymentCollected.objects.create(market=market_visit, **payment_data)

        for marketing_data in total_marketing_data:
            Marketing.objects.create(market=market_visit, **marketing_data)

        return market_visit
