from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from .models import (
    MarketVisit,
    Enquiries,
    QuotesSubmitted,
    ConfirmedWork,
    InvoiceWork,
    PaymentCollected,
    Profile,
    Customer,
    Marketing,
)
from users.models import SecureUser
from .serializers import (
    MarketVisitSerializer, ProfileSerializer, CustomerSerializer, 
    TotalEnquiriesSerializer, TotalQuotesSubmittedSerializer, TotalConfirmedWorkSerializer, TotalPaymentCollectedSerializer, TotalInvoiceWorkSerializer,
    MarketingSerializer
)


# class MarketingAPIView(APIView):
#     def get(self, request, pk=None):
#         if pk:
#             marking_data = Marketing.objects.filter(market__profiles__id=pk)
#         else:
#             marking_data = Marketing.objects.all()
#         marking_s = MarketingSerializer(marking_data, many=True)
#         return Response(marking_s.data)


# class EnquiriesAPIView(APIView):
#     def get(self, request, pk=None):
#         if pk:
#             enquiries_data = Enquiries.objects.filter(market__profiles__id=pk)
#         else:
#             enquiries_data = Enquiries.objects.all()
#         enquiries_s = TotalEnquiriesSerializer(enquiries_data, many=True)
#         return Response(enquiries_s.data)


# class QuotesSubmittedAPIView(APIView):
#     def get(self, request, pk=None):
#         if pk:
#             quotes_data = QuotesSubmitted.objects.filter(market__profiles__id=pk)
#         else:
#             quotes_data = QuotesSubmitted.objects.all()
#         quotes_s = TotalQuotesSubmittedSerializer(quotes_data, many=True)
#         return Response(quotes_s.data)


# class ConfirmedWorkAPIView(APIView):
#     def get(self, request, pk=None):
#         if pk:
#             confirm_data = ConfirmedWork.objects.filter(market__profiles__id=pk)
#         else:
#             confirm_data = ConfirmedWork.objects.all()
#         confirm_s = TotalConfirmedWorkSerializer(confirm_data, many=True)
#         return Response(confirm_s.data)


# class InvoiceWorkAPIView(APIView):
#     def get(self, request, pk=None):
#         if pk:
#             invoices_data = InvoiceWork.objects.filter(market__profiles__id=pk)
#         else:
#             invoices_data = InvoiceWork.objects.all()
#         invoices_s = TotalInvoiceWorkSerializer(invoices_data, many=True)
#         return Response(invoices_s.data)


# class PaymentCollectedAPIView(APIView):
#     def get(self, request, pk=None):
#         if pk:
#             payments_data = PaymentCollected.objects.filter(market__profiles__id=pk)
#         else:
#             payments_data = PaymentCollected.objects.all()
#         payments_s = TotalPaymentCollectedSerializer(payments_data, many=True)
#         return Response(payments_s.data)
    


class MarketingAPIView(APIView):
    def get(self, request, pk=None):
        if pk:
            marking_data = Marketing.objects.filter(market__profiles__id=pk).select_related('market__profiles')
        else:
            marking_data = Marketing.objects.all().select_related('market__profiles')
        marking_s = MarketingSerializer(marking_data, many=True)
        data = []
        for i, item in enumerate(marking_s.data):
            # Get the profile name directly from the queryset object
            profile_name = None
            if marking_data[i].market and marking_data[i].market.profiles:
                profile_name = marking_data[i].market.profiles.name
            item_with_profile = dict(item)
            item_with_profile['profile_name'] = profile_name
            data.append(item_with_profile)
        return Response({
            "data": data
        })


class EnquiriesAPIView(APIView):
    def get(self, request, pk=None):
        if pk:
            enquiries_data = Enquiries.objects.filter(market__profiles__id=pk).select_related('market__profiles')
        else:
            enquiries_data = Enquiries.objects.all().select_related('market__profiles')
        enquiries_s = TotalEnquiriesSerializer(enquiries_data, many=True)
        data = []
        for i, item in enumerate(enquiries_s.data):
            profile_name = None
            if enquiries_data[i].market and enquiries_data[i].market.profiles:
                profile_name = enquiries_data[i].market.profiles.name
            item_with_profile = dict(item)
            item_with_profile['profile_name'] = profile_name
            data.append(item_with_profile)
        return Response({
            "data": data
        })


class QuotesSubmittedAPIView(APIView):
    def get(self, request, pk=None):
        if pk:
            quotes_data = QuotesSubmitted.objects.filter(market__profiles__id=pk).select_related('market__profiles')
        else:
            quotes_data = QuotesSubmitted.objects.all().select_related('market__profiles')
        quotes_s = TotalQuotesSubmittedSerializer(quotes_data, many=True)
        data = []
        for i, item in enumerate(quotes_s.data):
            profile_name = None
            if quotes_data[i].market and quotes_data[i].market.profiles:
                profile_name = quotes_data[i].market.profiles.name
            item_with_profile = dict(item)
            item_with_profile['profile_name'] = profile_name
            data.append(item_with_profile)
        return Response({
            "data": data
        })


class ConfirmedWorkAPIView(APIView):
    def get(self, request, pk=None):
        if pk:
            confirm_data = ConfirmedWork.objects.filter(market__profiles__id=pk).select_related('market__profiles')
        else:
            confirm_data = ConfirmedWork.objects.all().select_related('market__profiles')
        confirm_s = TotalConfirmedWorkSerializer(confirm_data, many=True)
        data = []
        for i, item in enumerate(confirm_s.data):
            profile_name = None
            if confirm_data[i].market and confirm_data[i].market.profiles:
                profile_name = confirm_data[i].market.profiles.name
            item_with_profile = dict(item)
            item_with_profile['profile_name'] = profile_name
            data.append(item_with_profile)
        return Response({
            "data": data
        })


class InvoiceWorkAPIView(APIView):
    def get(self, request, pk=None):
        if pk:
            invoices_data = InvoiceWork.objects.filter(market__profiles__id=pk).select_related('market__profiles')
        else:
            invoices_data = InvoiceWork.objects.all().select_related('market__profiles')
        invoices_s = TotalInvoiceWorkSerializer(invoices_data, many=True)
        data = []
        for i, item in enumerate(invoices_s.data):
            profile_name = None
            if invoices_data[i].market and invoices_data[i].market.profiles:
                profile_name = invoices_data[i].market.profiles.name
            item_with_profile = dict(item)
            item_with_profile['profile_name'] = profile_name
            data.append(item_with_profile)
        return Response({
            "data": data
        })


class PaymentCollectedAPIView(APIView):
    def get(self, request, pk=None):
        if pk:
            payments_data = PaymentCollected.objects.filter(market__profiles__id=pk).select_related('market__profiles')
        else:
            payments_data = PaymentCollected.objects.all().select_related('market__profiles')
        payments_s = TotalPaymentCollectedSerializer(payments_data, many=True)
        data = []
        for i, item in enumerate(payments_s.data):
            profile_name = None
            if payments_data[i].market and payments_data[i].market.profiles:
                profile_name = payments_data[i].market.profiles.name
            item_with_profile = dict(item)
            item_with_profile['profile_name'] = profile_name
            data.append(item_with_profile)
        return Response({
            "data": data
        })





class MarketVisitFetchProfilesAPIView(APIView):
    def get(self, request, pk=None):
        if pk:
            marketing_data = MarketVisit.objects.filter(profiles__id=pk)
        else:
            marketing_data = MarketVisit.objects.all()
        marketing_s = MarketVisitSerializer(marketing_data, many=True)
        return Response(marketing_s.data)


class MarketVisitAPIView(APIView):
    def get(self, request, format=None):
        market_visits = MarketVisit.objects.all()
        serializer = MarketVisitSerializer(market_visits, many=True)
        return Response(serializer.data[::-1])

    def post(self, request, format=None):
        serializer = MarketVisitSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)
    
class FormComplatedView(APIView):
    def get(self, request, id, format=None):
        try: 
            market_visits = MarketVisit.objects.filter(profiles_id=id)
            if not market_visits.exists():
                return Response(
                    {'error': 'No market visits found for this profile'}, 
                    status=status.HTTP_404_NOT_FOUND
                )
            
            serializer = MarketVisitSerializer(market_visits, many=True)
            return Response(serializer.data[::-1])
        except Exception as e:
            return Response(
                {'error': str(e)}, 
                status=status.HTTP_400_BAD_REQUEST
            )

class ProfileAPIView(APIView):
    def post(self, request):
        serializer = ProfileSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)
    
    def get(self, request):
        profiles = Profile.objects.all().select_related('users')
        profile_data = ProfileSerializer(profiles, many=True).data

        # Build a mapping from profile id to user
        user_map = {}
        for profile in profiles:
            user = getattr(profile, 'users', None)
            if user:
                user_map[str(profile.id)] = user

        for profile in profile_data:
            user = user_map.get(str(profile['id']))
            if user:
                profile['user_email'] = user.email
                profile['created_at'] = user.created_at
            else:
                profile['user_email'] = None
                profile['created_at'] = None

        return Response(profile_data)
    

class CustomerAPIView(APIView):
    def post(self, request):
        inputs_data = CustomerSerializer(data=request.data)
        if inputs_data.is_valid():
            inputs_data.save()
            return Response(inputs_data.data, status=status.HTTP_201_CREATED)
        return Response(inputs_data.errors, status=status.HTTP_400_BAD_REQUEST)
    
    def get(self, request):
        customers = Customer.objects.all()
        customers_data = CustomerSerializer(customers, many=True).data
        if customers_data:
            return Response(customers_data, status=status.HTTP_200_OK)
        return Response(status=status.HTTP_404_NOT_FOUND)

