# from django.contrib import admin
# from django.urls import re_path
# from users.views import (
#     UserRegistration,
#     UserLogin,
#     PasswordReset,
#     PasswordChange,
#     AdminUserLogin,
#     GetUsers,
#     RecentActivities,
# )
# from plutontech.csrf_cookie import get_csrf_token

# from employer_profile.views import MarketVisitAPIView, ProfileAPIView, FormComplatedView, CustomerAPIView

# urlpatterns = [
#     # CSRF
#     re_path('csrf/', get_csrf_token),

#     # ADMIN
#     re_path('api/pluto/tech/admin', admin.site.urls),

#     # AUTH
#     re_path('api/register', UserRegistration.as_view(), name="users-register"),
#     re_path('api/login', UserLogin.as_view(), name="users-login"),
#     re_path('api/admin/login', AdminUserLogin.as_view(), name="admins-login"),
#     re_path('api/forgot-password', PasswordReset.as_view(), name='forgot-passwords'),
#     re_path('api/change-password', PasswordChange.as_view(), name='change-passwords'),
#     re_path('api/users/get', GetUsers.as_view(), name="get-users"),
    
#     # EMPLOYER API
#     re_path('api/employer/create', MarketVisitAPIView.as_view(), name="employer-create"),
#     re_path('api/employer/get', MarketVisitAPIView.as_view(), name="get-employer"),
#     re_path('api/employer/form-completed/(?P<id>\d+)', FormComplatedView.as_view(), name="form-completed"),

#     # PROFILES
#     re_path('api/profiles/create', ProfileAPIView.as_view(), name="profiles-create"),
#     re_path('api/profiles/get', ProfileAPIView.as_view(), name="get-profiles"),

#     re_path('api/activities', RecentActivities.as_view(), name="recent-activities"),

#     # Customer 
#     re_path('api/customer/create', CustomerAPIView.as_view(), name="customer-create"),
#     re_path('api/customer/get', CustomerAPIView.as_view(), name="get-customer"),
# ]




from django.contrib import admin
from django.urls import re_path
from users.views import (
    UserRegistration,
    UserLogin,
    PasswordReset,
    PasswordChange,
    AdminUserLogin,
    GetUsers,
    RecentActivities,
)
from plutontech.csrf_cookie import get_csrf_token

from employer_profile.views import (
    MarketVisitAPIView, ProfileAPIView, FormComplatedView, CustomerAPIView,
    EnquiriesAPIView, QuotesSubmittedAPIView, ConfirmedWorkAPIView, InvoiceWorkAPIView, PaymentCollectedAPIView,
    MarketingAPIView, MarketVisitFetchProfilesAPIView
)


urlpatterns = [
    # CSRF
    re_path('csrf/', get_csrf_token),

    # ADMIN
    re_path('api/pluto/tech/admin', admin.site.urls),

    # AUTH
    re_path('api/register', UserRegistration.as_view(), name="users-register"),
    re_path('api/login', UserLogin.as_view(), name="users-login"),
    re_path('api/admin/login', AdminUserLogin.as_view(), name="admins-login"),
    re_path('api/forgot-password', PasswordReset.as_view(), name='forgot-passwords'),
    re_path('api/change-password', PasswordChange.as_view(), name='change-passwords'),
    re_path('api/users/get', GetUsers.as_view(), name="get-users"),
    
    # EMPLOYER API
    re_path('api/employer/create', MarketVisitAPIView.as_view(), name="employer-create"),
    re_path('api/employer/get', MarketVisitAPIView.as_view(), name="get-employer"),
    re_path('api/employer/form-completed/(?P<id>\d+)', FormComplatedView.as_view(), name="form-completed"),

    # PROFILES
    re_path('api/profiles/create', ProfileAPIView.as_view(), name="profiles-create"),
    re_path('api/profiles/get', ProfileAPIView.as_view(), name="get-profiles"),

    re_path('api/activities', RecentActivities.as_view(), name="recent-activities"),

    # Customer 
    re_path('api/customer/create', CustomerAPIView.as_view(), name="customer-create"),
    re_path('api/customer/get', CustomerAPIView.as_view(), name="get-customer"),


    # All Api

    re_path(r'^api/pluton/get/enquiries(?:/(?P<pk>[0-9a-f-]+))?$', EnquiriesAPIView.as_view(), name="get-enquiries"),
    re_path(r'^api/pluton/get/quote(?:/(?P<pk>[0-9a-f-]+))?$', QuotesSubmittedAPIView.as_view(), name="get-quote"),
    re_path(r'^api/pluton/get/confirm(?:/(?P<pk>[0-9a-f-]+))?$', ConfirmedWorkAPIView.as_view(), name="get-confirm"),
    re_path(r'^api/pluton/get/invoices(?:/(?P<pk>[0-9a-f-]+))?$', InvoiceWorkAPIView.as_view(), name="get-invoices"),
    re_path(r'^api/pluton/get/payment(?:/(?P<pk>[0-9a-f-]+))?$', PaymentCollectedAPIView.as_view(), name="get-payment"),
    re_path(r'^api/pluton/get/marketing(?:/(?P<pk>[0-9a-f-]+))?$', MarketingAPIView.as_view(), name="get-marketing"),
    re_path(r'^api/pluton/get/market/profile(?:/(?P<pk>[0-9a-f-]+))?$', MarketVisitFetchProfilesAPIView.as_view(), name="get-marketing"),

]
