from django.db import models

class SecureUser(models.Model):
    email = models.EmailField(unique=True)
    password_hash = models.CharField(max_length=256)
    salt = models.BinaryField(max_length=64)
    is_active = models.BooleanField(default=True)
    last_login = models.DateTimeField(null=True)
    failed_login_attempts = models.IntegerField(default=0)
    account_locked_until = models.DateTimeField(null=True, blank=True)
    is_admin = models.BooleanField(default=False)
    
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        indexes = [
            models.Index(fields=['email']),
        ]



class FailedLoginAttempt(models.Model):
    user = models.ForeignKey(SecureUser, on_delete=models.CASCADE, related_name='failed_attempts')
    timestamp = models.DateTimeField(auto_now_add=True)
    ip_address = models.GenericIPAddressField(null=True)
    user_agent = models.TextField(null=True)

    class Meta:
        indexes = [
            models.Index(fields=['user', 'timestamp']),
        ]

class LoginActivity(models.Model):
    user = models.ForeignKey(SecureUser, on_delete=models.CASCADE, related_name='login_activities')
    timestamp = models.DateTimeField(auto_now_add=True)
    status = models.CharField(max_length=20)  # 'success' or 'failed'
    ip_address = models.GenericIPAddressField(null=True)
    user_agent = models.TextField(null=True)

    class Meta:
        indexes = [
            models.Index(fields=['user', 'timestamp']),
        ]
